/*
 * Decompiled with CFR 0.152.
 */
package GameState;

import Audio.AudioPlayer;
import Entity.MenuOption;
import Entity.Mouse;
import GameState.GameState;
import GameState.GameStateManager;
import Handlers.Content;
import Handlers.Keys;
import Handlers.Options;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class MenuState
extends GameState {
    private BufferedImage title;
    private BufferedImage titleShip;
    private int currentChoice = 0;
    private String[] options = new String[]{"Game Start", "Difficulty", "High Scores", "How to Play", "Options", "Credits", "Exit Game"};
    private Color colorText;
    private Color colorFade;
    private int alpha = 255;
    private boolean once = false;
    private boolean entered = false;
    private long startTime;
    private int a;
    private int titley = 0;
    private int shipy = 10;
    private int texty = 595;
    private int bary = 285;
    private Font fontSmall;
    private MenuOption mo;
    private Mouse mouse;

    public MenuState(GameStateManager gsm) {
        this.gsm = gsm;
        try {
            this.titleShip = Content.SpaceshipIntro;
            this.title = Content.CometDefender;
            this.fontSmall = new Font("Arial", 0, 18);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mouse = new Mouse();
        this.mo = new MenuOption(this.options, gsm.regFont, 400, 125, 0, 40);
        this.startTime = System.nanoTime();
        this.a = 3;
        if (GameStateManager.firstTime) {
            this.entered = true;
            this.alpha = 255;
            this.titley = -135;
            this.shipy = 900;
            this.bary = 500;
            this.texty = 910;
        }
    }

    @Override
    public void init() {
    }

    @Override
    public void update() {
        long elapsed;
        this.handleInput();
        this.mouse.update();
        if (this.alpha == 255 && this.titley == -135) {
            this.mo.update(this.mouse);
        }
        if ((elapsed = (System.nanoTime() - this.startTime) / 1000000L) > 3L && !this.entered) {
            this.startTime = System.nanoTime();
            this.alpha -= this.a;
            if (this.alpha < 0) {
                this.alpha = 0;
            }
            if (this.alpha > 255) {
                this.alpha = 255;
            }
            if (this.alpha == 0) {
                this.a = -3;
                this.once = true;
            }
            if (this.alpha == 255) {
                this.a = 3;
            }
        }
        if (elapsed > 3L && this.alpha != 255 && this.entered && this.titley == -135) {
            this.startTime = System.nanoTime();
            this.alpha += 5;
            if (this.alpha > 255) {
                this.alpha = 255;
            }
        }
        this.colorText = new Color(255, 255, 255, this.alpha);
        this.colorFade = new Color(0, 0, 0, this.alpha);
    }

    @Override
    public void draw(Graphics2D g) {
        if (!this.entered) {
            g.drawImage((Image)this.titleShip, 350, 10, null);
            g.drawImage((Image)this.title, 0, 0, null);
            g.setColor(new Color(0, 0, 0, 150));
            g.fillRect(0, 285, 800, 30);
            g.setFont(this.gsm.regFont);
            g.setColor(this.colorText);
            this.gsm.drawCenteredString("Press Enter", 800, 595, g);
            g.setColor(Color.black);
            g.setColor(this.colorFade);
            if (!this.once) {
                g.fillRect(0, 0, 800, 400);
            }
        } else {
            if (this.shipy < 895) {
                g.drawImage((Image)this.titleShip, 350, this.shipy, null);
            }
            g.drawImage((Image)this.title, 0, this.titley, null);
            if (this.titley > -135) {
                this.titley -= 3;
            }
            if (this.shipy < 900) {
                this.shipy += 8;
            }
            g.setColor(new Color(0, 0, 0, 150));
            if (this.bary < 495) {
                g.fillRect(0, this.bary, 800, 30);
            }
            if (this.bary < 500) {
                this.bary += 3;
            }
            g.setFont(this.gsm.regFont);
            g.setColor(Color.white);
            if (this.texty < 900) {
                this.gsm.drawCenteredString("Press Enter", 800, this.texty, g);
            }
            if (this.texty < 910) {
                this.texty += 6;
            }
            g.setFont(this.gsm.regFont);
            g.setColor(this.colorText);
            if (Options.getOption(5)) {
                this.mo.draw(g);
                this.mouse.draw(g);
            } else {
                int i = 0;
                while (i < this.options.length) {
                    if (i == this.currentChoice) {
                        if (this.alpha == 255 && this.titley == -135) {
                            g.setColor(Color.YELLOW);
                        }
                    } else if (this.alpha == 255 && this.titley == -135) {
                        g.setColor(Color.WHITE);
                    }
                    this.gsm.drawCenteredString(this.options[i], 800, 250 + i * 80, g);
                    ++i;
                }
            }
        }
        g.setFont(this.fontSmall);
        g.setColor(Color.white);
        g.drawString("Version 1.2", 10, 390);
    }

    private void select(int currentChoice) {
        if (currentChoice == 0) {
            this.gsm.setState(1);
            AudioPlayer.stop("introMusic");
        }
        if (currentChoice == 1) {
            this.gsm.setState(3);
        }
        if (currentChoice == 2) {
            this.gsm.setState(4);
        }
        if (currentChoice == 3) {
            this.gsm.setState(5);
        }
        if (currentChoice == 4) {
            this.gsm.setState(6);
        }
        if (currentChoice == 5) {
            this.gsm.setState(7);
        }
        if (currentChoice == 6) {
            System.exit(0);
        }
    }

    @Override
    public void handleInput() {
        if (this.entered) {
            if (Options.getOption(5)) {
                if (Keys.isMousePressed(Keys.LEFTCLICK)) {
                    this.select(this.mo.getChoice());
                }
            } else {
                if (Keys.isKeyPressed(Keys.ENTER) && this.titley == -135 && this.alpha == 255) {
                    this.select(this.currentChoice);
                }
                if (Keys.isKeyPressed(Keys.UP) && this.titley == -135 && this.alpha == 255) {
                    this.currentChoice = this.currentChoice > 0 ? --this.currentChoice : this.options.length - 1;
                }
                if (Keys.isKeyPressed(Keys.DOWN) && this.titley == -135 && this.alpha == 255) {
                    this.currentChoice = this.currentChoice < this.options.length - 1 ? ++this.currentChoice : 0;
                }
            }
        }
        if (Keys.isKeyPressed(Keys.ENTER) && !this.entered && !GameStateManager.firstTime) {
            this.entered = true;
            this.alpha = 0;
            this.startTime = System.nanoTime();
            GameStateManager.firstTime = true;
        }
        if (Keys.isKeyPressed(Keys.ESCAPE)) {
            System.exit(0);
        }
    }
}

